/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LambdaExceptionUtils;
import cpw.mods.modlauncher.api.NamedPath;
import cpw.mods.modlauncher.serviceapi.ITransformerDiscoveryService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.TransformerDiscovererConstants;
import org.slf4j.Logger;

public class ModDirTransformerDiscoverer
implements ITransformerDiscoveryService {
    private static final Logger LOGGER = LogUtils.getLogger();
    private UncheckedIOException alreadyFailed;
    private static final List<NamedPath> found = new ArrayList<NamedPath>();

    public List<NamedPath> candidates(Path gameDirectory, String launchTarget) {
        try {
            FMLPaths.loadAbsolutePaths(gameDirectory);
            FMLConfig.load();
            return this.candidates(gameDirectory);
        }
        catch (UncheckedIOException e) {
            this.alreadyFailed = e;
            return List.of();
        }
    }

    public void earlyInitialization(String launchTarget, String[] arguments) {
        ImmediateWindowHandler.load(launchTarget, arguments);
        if (this.alreadyFailed != null) {
            String errorCause;
            IOException iOException = this.alreadyFailed.getCause();
            if (iOException instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException faee = (FileAlreadyExistsException)iOException;
                errorCause = "File already exists: " + faee.getFile() + "\nYou need to move this out of the way, so we can put a directory there.";
            } else {
                iOException = this.alreadyFailed.getCause();
                if (iOException instanceof AccessDeniedException) {
                    AccessDeniedException ade = (AccessDeniedException)iOException;
                    errorCause = "Access denied trying to create a file or directory " + ade.getMessage() + "\nThe game directory is probably read-only. Check the write permission on it.";
                } else {
                    errorCause = "An unexpected IO error occurred trying to setup the game directory\n" + this.alreadyFailed.getCause().getMessage();
                }
            }
            ImmediateWindowHandler.crash(errorCause);
            throw this.alreadyFailed;
        }
    }

    public List<NamedPath> candidates(Path gameDirectory) {
        ModDirTransformerDiscoverer.scan(gameDirectory);
        return List.copyOf(found);
    }

    public static List<Path> allExcluded() {
        return found.stream().map(np -> np.paths()[0]).toList();
    }

    private static void scan(Path gameDirectory) {
        Path modsDir = gameDirectory.resolve(FMLPaths.MODSDIR.relative()).toAbsolutePath().normalize();
        if (!Files.exists(modsDir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walk = Files.walk(modsDir, 1, new FileVisitOption[0]);){
            walk.toList().parallelStream().filter(ModDirTransformerDiscoverer::shouldLoadInServiceLayer).forEachOrdered(p -> found.add(new NamedPath(p.getFileName().toString(), new Path[]{p})));
        }
        catch (IOException | IllegalStateException ioe) {
            LOGGER.error("Error during early discovery", (Throwable)ioe);
        }
    }

    private static boolean shouldLoadInServiceLayer(Path path) {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        if (!path.toString().endsWith(".jar")) {
            return false;
        }
        if ((Long)LambdaExceptionUtils.uncheck(() -> Files.size(path)) == 0L) {
            return false;
        }
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(path);
    }
}

